package net.w_horse.excelpojo.converter;

import java.util.HashMap;

import org.springframework.util.StringUtils;

/**
 * ZƃtB[hɑ΂^UɊւϊsNX<br>
 * boolean, ƕ̑ݕϊsB<BR>
 * Ⴆ΁~̂悤Ȑ^U\boolean𑊌݂ɕϊB<br>
 * Ԃł͕ "true" / "false"  boolean ̑ݕϊsB<br>
 * \ߗpӂĂ}bsO<br>
 * {@link #TYPE_TRUE_FALSE}, {@link #TYPE_YES_NO}, {@link #TYPE_OX},<br>
 * {@link #TYPE_ON_OFF}, {@link #TYPE_OK_CANCEL}, {@link #TYPE_10},<br>
 * {@link #TYPE_10_INTEGER}<br>
 * }bsO̗v̂́AMap<Object, Object>[]pӂA<br>
 * ẑOԖڂɃZtB[hAPԖڂɃtB[hZ̃}bv`B<br>
 * ꂼ̃}bvɂ́AzO̒lɑ΂߂lƂāA<br>
 * #FALSE}L[ɂ}bsO`ĂB<br>
 *
 * @author kawahara
 *
 */
@SuppressWarnings("unchecked")
public class StringBooleanConverter implements CellFieldConverter {
	/**
	 * booleañ}bsO<br>
	 * ftHgRXgN^Ŏgp^Cv<br>
	 * True/FalsẽP[X<br>
	 * ̑啶E͖<br>
	 * boolean̕ϊ͏ true / false Ԃ<br>
	 * trueFtrue false:false<br>
	 *
	 */
	public static final HashMap<Object, Object>[] TYPE_TRUE_FALSE;
	/**
	 * booleañ}bsO<br>
	 * Yes/NõP[X<br>
	 * ̑啶E͖<br>
	 * Yes̏ȗƂYNȍȗƂNF<br>
	 * boolean̕ϊ͏ yes / no Ԃ<br>
	 * yesFtrue no:false<br>
	 */
	public static final HashMap<Object, Object>[] TYPE_YES_NO;
	/**
	 * booleañ}bsO<br>
	 * /~̃P[X<br>
	 * Ftrue ~:false<br>
	 */
	public static final HashMap<Object, Object>[] TYPE_OX;
	/**
	 * booleañ}bsO<br>
	 * On/Off̃P[X<br>
	 * ̑啶E͖<br>
	 * boolean̕ϊ͏ on / off Ԃ<br>
	 * onFtrue off:false<br>
	 */
	public static final HashMap<Object, Object>[] TYPE_ON_OFF;
	/**
	 * booleañ}bsO<br>
	 * 1/0̃P[X<br>
	 * 1Ftrue 0:false<br>
	 */
	public static final HashMap<Object, Object>[] TYPE_10;
	/**
	 * lbooleañ}bsO<br>
	 * 1/0̃P[X<br>
	 * 1Ftrue 0:false<br>
	 */
	public static final HashMap<Object, Object>[] TYPE_10_INTEGER;
	/**
	 * booleañ}bsO<br>
	 * OK/CANCEL̃P[X<br>
	 * ̑啶E͖<br>
	 * boolean̕ϊ͏ ok / cancel Ԃ<br>
	 * okFtrue cancel:false<br>
	 */
	public static final HashMap<Object, Object>[] TYPE_OK_CANCEL;

	/**
	 * Ԃۂ̃^Cv<br>
	 * NOTHING:Ȃ<br>
	 * UPPER_CASE:ׂđ啶ɂ<br>
	 * LOWER_CASE:ׂďɂ<br>
	 * CAPITALIZE:擪̕啶ɂ<br>
	 * UN_CAPITARIZE:擪̕ɂ<br>
	 *
	 * @author kawahara
	 *
	 */
	public enum CapitalizeType {NOTHING, UPPER_CASE, LOWER_CASE, CAPITALIZE, UN_CAPITARIZE};

	private enum FalseType {FALSE}
	public static final FalseType FALSE ;

	static {
		FALSE = FalseType.FALSE;

		TYPE_TRUE_FALSE = new HashMap[2];
		TYPE_TRUE_FALSE[0] = new HashMap<Object, Object>();
		TYPE_TRUE_FALSE[0].put("true", Boolean.TRUE);
		TYPE_TRUE_FALSE[0].put("false", Boolean.FALSE);
		TYPE_TRUE_FALSE[0].put(FALSE, Boolean.FALSE);
		TYPE_TRUE_FALSE[1] = new HashMap<Object, Object>();
		TYPE_TRUE_FALSE[1].put(Boolean.TRUE, "true");
		TYPE_TRUE_FALSE[1].put(Boolean.FALSE, "false");
		TYPE_TRUE_FALSE[1].put(FALSE, "false");

		TYPE_YES_NO = new HashMap[2];
		TYPE_YES_NO[0] = new HashMap<Object, Object>();
		TYPE_YES_NO[0].put("yes", Boolean.TRUE);
		TYPE_YES_NO[0].put("no", Boolean.FALSE);
		TYPE_YES_NO[0].put("y", Boolean.TRUE);
		TYPE_YES_NO[0].put("n", Boolean.FALSE);
		TYPE_YES_NO[0].put(FALSE, Boolean.FALSE);
		TYPE_YES_NO[1] = new HashMap<Object, Object>();
		TYPE_YES_NO[1].put(Boolean.TRUE, "yes");
		TYPE_YES_NO[1].put(Boolean.FALSE, "no");
		TYPE_YES_NO[1].put(FALSE, "no");

		TYPE_OX = new HashMap[2];
		TYPE_OX[0] = new HashMap<Object, Object>();
		TYPE_OX[0].put("", Boolean.TRUE);
		TYPE_OX[0].put("~", Boolean.FALSE);
		TYPE_OX[0].put(FALSE, Boolean.FALSE);
		TYPE_OX[1] = new HashMap<Object, Object>();
		TYPE_OX[1].put(Boolean.TRUE, "");
		TYPE_OX[1].put(Boolean.FALSE, "~");
		TYPE_OX[1].put(FALSE, "~");

		TYPE_ON_OFF = new HashMap[2];
		TYPE_ON_OFF[0] = new HashMap<Object, Object>();
		TYPE_ON_OFF[0].put("on", Boolean.TRUE);
		TYPE_ON_OFF[0].put("off", Boolean.FALSE);
		TYPE_ON_OFF[0].put(FALSE, Boolean.FALSE);
		TYPE_ON_OFF[1] = new HashMap<Object, Object>();
		TYPE_ON_OFF[1].put(Boolean.TRUE, "on");
		TYPE_ON_OFF[1].put(Boolean.FALSE, "off");
		TYPE_ON_OFF[1].put(FALSE, "off");

		TYPE_10 = new HashMap[2];
		TYPE_10[0] = new HashMap<Object, Object>();
		TYPE_10[0].put("1", Boolean.TRUE);
		TYPE_10[0].put("0", Boolean.FALSE);
		TYPE_10[0].put(FALSE, Boolean.FALSE);
		TYPE_10[1] = new HashMap<Object, Object>();
		TYPE_10[1].put(Boolean.TRUE, "1");
		TYPE_10[1].put(Boolean.FALSE, "0");
		TYPE_10[1].put(FALSE, "0");

		TYPE_10_INTEGER = new HashMap[2];
		TYPE_10_INTEGER[0] = new HashMap<Object, Object>();
		TYPE_10_INTEGER[0].put(1, Boolean.TRUE);
		TYPE_10_INTEGER[0].put(0, Boolean.FALSE);
		TYPE_10_INTEGER[0].put(FALSE, Boolean.FALSE);
		TYPE_10_INTEGER[1] = new HashMap<Object, Object>();
		TYPE_10_INTEGER[1].put(Boolean.TRUE, 1);
		TYPE_10_INTEGER[1].put(Boolean.FALSE, 0);
		TYPE_10_INTEGER[1].put(FALSE, 0);

		TYPE_OK_CANCEL = new HashMap[2];
		TYPE_OK_CANCEL[0] = new HashMap<Object, Object>();
		TYPE_OK_CANCEL[0].put("ok", Boolean.TRUE);
		TYPE_OK_CANCEL[0].put("cancel", Boolean.FALSE);
		TYPE_OK_CANCEL[0].put(FALSE, Boolean.FALSE);
		TYPE_OK_CANCEL[1] = new HashMap<Object, Object>();
		TYPE_OK_CANCEL[1].put(Boolean.TRUE, "ok");
		TYPE_OK_CANCEL[1].put(Boolean.FALSE, "cancel");
		TYPE_OK_CANCEL[1].put(FALSE, "cancel");
	}


	private HashMap<Object, Object>[] mappings = TYPE_TRUE_FALSE;
	private boolean ignoreCase = true;
	private CapitalizeType capitalizeType = CapitalizeType.NOTHING;

	/**
	 * ftHgRXgN^̏ꍇ
	 * }bsO {@link #TYPE_TRUE_FALSE}pA
	 * }bsO̔rɑ΂A啶E𖳎A
	 * Ԃۂ̃^CvCapitalizeType.NOTHINGp
	 */
	public StringBooleanConverter() {
		this.mappings = TYPE_TRUE_FALSE;
		this.ignoreCase = true;
		this.capitalizeType = CapitalizeType.NOTHING;
	}

	@Override
	public Object convertCell2Field(Object value) {
		return getValue(value, this.mappings[0]);
	}

	@Override
	public Object convertField2Cell(Object value) {
		return getValue(value, this.mappings[1]);
	}

	public void setMappings(HashMap<Object, Object>[] mappings) {
		this.mappings = mappings;
	}
	public void setIgnoreCase(boolean ignoreCase) {
		this.ignoreCase = ignoreCase;
	}
	public void setCapitalizeType(CapitalizeType capitalizeType) {
		this.capitalizeType = capitalizeType;
	}

	private Object getValue(Object searchKey, HashMap<Object, Object> mapping) {
		Object retValue = null;
		if (searchKey instanceof String) {
			for (Object key : mapping.keySet()) {
				if (!key.getClass().equals(String.class)) continue;

				if((((String)searchKey).equals((String) key))
					|| (this.ignoreCase && ((String)searchKey).equalsIgnoreCase((String) key))
				) {
					retValue = mapping.get(key);
					break;
				}
			}
		} else {
			retValue = mapping.get(searchKey);
		}
		if (retValue == null) {
			retValue = mapping.get(FALSE);
		}
		return (retValue instanceof String ? capitalize((String) retValue) : retValue);
	}

	private String capitalize(String value) {
		String retValue;
		switch(this.capitalizeType) {
		case UPPER_CASE:
			retValue = value.toUpperCase();
			break;
		case LOWER_CASE:
			retValue = value.toLowerCase();
			break;
		case CAPITALIZE:
			retValue = StringUtils.capitalize(value);
			break;
		case UN_CAPITARIZE:
			retValue = StringUtils.uncapitalize(value);
			break;
		default:
			retValue = value;
		}
		return retValue;
	}

}
